package org.retentionprediction;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Vector;

import javax.help.CSH;
import javax.help.HelpSet;
import javax.swing.JApplet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.SwingWorker;

class Compound
{
	String strCompoundName;
	int iCompoundIndex;

	static public int getCompoundNum()
	{
		return Globals.CompoundNameArray.length;
	}
	
	public boolean loadCompoundInfo(int iIndex)
	{
		iCompoundIndex = iIndex;
		
		strCompoundName = Globals.CompoundNameArray[iIndex];
		
		return true;
	}
}

public class RetentionPredictorApplet extends JApplet implements ActionListener, KeyListener, FocusListener, ListSelectionListener, AutoScaleListener, TableModelListener
{
	private static final long serialVersionUID = 1L;

	TopPanel contentPane = null;
	TopPanel2 contentPane2 = null;
	public int m_iStationaryPhase = 0;
	public double m_dStartingComposition = 0.1;
	public double m_dEndingComposition = 1;
	public double m_dGradientTime = 20;
	public double m_dFlowRate = 0.2;
	public int m_iNumPoints = 3000;
	public Vector<Object[]> m_vectCalSolutes = new Vector<Object[]>();
    private Task task;
    private TaskPredict taskPredict;
    public int m_iStage = 1;
    public double m_dtstep = 0.01;
    
    public InterpolationFunction m_InterpolatedGradient;
    public double[][] m_dGradientArray;
    public InterpolationFunction m_InterpolatedFlowRate;
    public double[][] m_dFlowRateArray;
    public InterpolationFunction[] m_IsocraticDataInterpolated;
    public InterpolationFunction m_Vm;
	
    public int m_iInterpolatedGradientSeries = 0;
    public int m_iGradientMarkerSeries = 0;
    public int m_iInterpolatedFlowSeries = 0;
    public int m_iFlowRateMarkerSeries = 0;
    
    public double m_dPlotXMax = 0;
    public double m_dPlotXMax2 = 0;
    
	public Vector<Compound> m_vectCompound = new Vector<Compound>();
	/**
	 * This is the xxx default constructor
	 */
	public RetentionPredictorApplet() 
	{
	    super();
	    
		/*try {
	        //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	        UIManager.setLookAndFeel("org.jdesktop.swingx.plaf.nimbus");
	    } 
	    catch (UnsupportedLookAndFeelException e) {
	       // handle exception
	    }
	    catch (ClassNotFoundException e) {
	       // handle exception
	    }
	    catch (InstantiationException e) {
	       // handle exception
	    }
	    catch (IllegalAccessException e) {
	       // handle exception
	    }*/

		this.setPreferredSize(new Dimension(900, 650));
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	public void init() 
	{
        // Load the JavaHelp
		String helpHS = "org/retentionprediction/help/RetentionPredictorHelp.hs";
		ClassLoader cl = TopPanel.class.getClassLoader();
		try {
			URL hsURL = HelpSet.findHelpSet(cl, helpHS);
			Globals.hsMainHelpSet = new HelpSet(null, hsURL);
		} catch (Exception ee) {
			System.out.println( "HelpSet " + ee.getMessage());
			System.out.println("HelpSet "+ helpHS +" not found");
			return;
		}
		Globals.hbMainHelpBroker = Globals.hsMainHelpSet.createHelpBroker();

		//Execute a job on the event-dispatching thread; creating this applet's GUI.
        try {
        //    SwingUtilities.invokeAndWait(new Runnable() 
        //    {
        //        public void run() {
                	createGUI();
        //        }
        //    });
        } catch (Exception e) { 
            System.err.println("createGUI didn't complete successfully");
            System.err.println(e.getMessage());
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.toString());
            System.err.println(e.getStackTrace());
            System.err.println(e.getCause());
        }
        
        performValidations();
        
    }
    
    private void createGUI()
    {
        //Create and set up the first content pane (steps 1-4).
        contentPane = new TopPanel();
        contentPane.setOpaque(true); 
        setContentPane(contentPane);  

        contentPane.jtxtInitialSolventComposition.addFocusListener(this);
        contentPane.jtxtInitialSolventComposition.addKeyListener(this);
        contentPane.jtxtFinalSolventComposition.addFocusListener(this);
        contentPane.jtxtFinalSolventComposition.addKeyListener(this);
        contentPane.jtxtGradientTime.addFocusListener(this);
        contentPane.jtxtGradientTime.addKeyListener(this);
        contentPane.jtxtFlowRate.addFocusListener(this);
        contentPane.jtxtFlowRate.addKeyListener(this);
        contentPane.jbtnHelp.addActionListener(this);
        contentPane.m_GraphControl.addAutoScaleListener(this);
        contentPane.m_GraphControlFlow.addAutoScaleListener(this);
        contentPane.tmSelectCompounds.addTableModelListener(this);
        contentPane.tmMeasuredRetentionTimes.addTableModelListener(this);
        contentPane.jbtnNextStep.addActionListener(this);
        contentPane.jbtnPreloadedValues.addActionListener(this);
        
        contentPane.m_GraphControl.setYAxisTitle("Eluent Composition");
        contentPane.m_GraphControl.setYAxisBaseUnit("%B", "%");
        contentPane.m_GraphControl.setYAxisRangeLimits(0, 105);
        contentPane.m_GraphControl.setYAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControl.setXAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControl.setAutoScaleY(true);
        //contentPane.m_GraphControl.setVisibleWindow(0, 300, 0, 110);
        contentPane.m_GraphControl.repaint();

        contentPane.m_GraphControlFlow.setYAxisTitle("Flow Rate");
        contentPane.m_GraphControlFlow.setYAxisBaseUnit("liter/min", "L/min");
        contentPane.m_GraphControlFlow.setYAxisRangeLimits(0, 10000);
        contentPane.m_GraphControlFlow.setYAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControlFlow.setXAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControlFlow.setAutoScaleY(true);
        //contentPane.m_GraphControlFlow.setVisibleWindow(0, 300, 0.195 / 1000, 0.205 / 1000);
        contentPane.m_GraphControlFlow.repaint();
        
        //Create and set up the second content pane
        contentPane2 = new TopPanel2();
        contentPane2.setOpaque(true); 
        contentPane2.jpanelStep6.setVisible(false);
        
        contentPane2.jbtnCalculate.addActionListener(this);
        contentPane2.jbtnNextStep.addActionListener(this);
        contentPane2.jbtnPreviousStep.addActionListener(this);
        contentPane2.jbtnPredict.addActionListener(this);
        contentPane2.jbtnHelp.addActionListener(this);

        contentPane2.m_GraphControl.setYAxisTitle("Eluent Composition");
        contentPane2.m_GraphControl.setYAxisBaseUnit("%B", "%");
        contentPane2.m_GraphControl.setYAxisRangeLimits(0, 105);
        contentPane2.m_GraphControl.setYAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControl.setXAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControl.setAutoScaleY(true);
        //contentPane.m_GraphControl.setVisibleWindow(0, 300, 0, 110);
        contentPane2.m_GraphControl.repaint();

        contentPane2.m_GraphControlFlow.setYAxisTitle("Flow Rate");
        contentPane2.m_GraphControlFlow.setYAxisBaseUnit("liter/min", "L/min");
        contentPane2.m_GraphControlFlow.setYAxisRangeLimits(0, 10000);
        contentPane2.m_GraphControlFlow.setYAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControlFlow.setXAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControlFlow.setAutoScaleY(true);
        //contentPane.m_GraphControlFlow.setVisibleWindow(0, 300, 0.195 / 1000, 0.205 / 1000);
        contentPane2.m_GraphControlFlow.repaint();       
    }

    private void validateStartingComposition()
    {
		double dTemp = (double)Float.valueOf(contentPane.jtxtInitialSolventComposition.getText());
		
		if (dTemp < 0)
			dTemp = 0;
		if (dTemp > 100)
			dTemp = 100;
		
		this.m_dStartingComposition = dTemp / 100;
		contentPane.jtxtInitialSolventComposition.setText(Float.toString((float)dTemp));    	
    }

    private void validateFinalComposition()
    {
		double dTemp = (double)Float.valueOf(contentPane.jtxtFinalSolventComposition.getText());
		
		if (dTemp < 0)
			dTemp = 0;
		if (dTemp > 100)
			dTemp = 100;
		
		this.m_dEndingComposition = dTemp / 100;
		contentPane.jtxtFinalSolventComposition.setText(Float.toString((float)dTemp));    	
    }

    private void validateGradientTime()
    {
		double dTemp = (double)Float.valueOf(contentPane.jtxtGradientTime.getText());
		
		if (dTemp < 0.1)
			dTemp = 0.1;
		if (dTemp > 10000)
			dTemp = 10000;
		
		this.m_dGradientTime = dTemp;
		contentPane.jtxtGradientTime.setText(Float.toString((float)m_dGradientTime));    	
    }

    private void validateFlowRate()
    {
		double dTemp = (double)Float.valueOf(contentPane.jtxtFlowRate.getText());
		
		if (dTemp < 0.000000001)
			dTemp = 0.000000001;
		if (dTemp > 10000)
			dTemp = 10000;
		
		this.m_dFlowRate = dTemp;
		contentPane.jtxtFlowRate.setText(Float.toString((float)m_dFlowRate));    	
    }

    public void actionPerformed(ActionEvent evt) 
	{
	    String strActionCommand = evt.getActionCommand();

	    if (strActionCommand == "Help")
	    {
			Globals.hbMainHelpBroker.setCurrentID("step-by-step");
			Globals.hbMainHelpBroker.setDisplayed(true);
	    }
	    else if (strActionCommand == "Next Step")
	    {
	    	// Set the graph and flow profiles to contain the correct data
	    	m_iStage = 2;

	    	// Set initial control values
	    	contentPane2.jbtnCalculate.setText("Back-Calculate Profiles");
	    	contentPane2.jbtnCalculate.setEnabled(true);
	    	contentPane2.jlblIterationNumber.setText("1");
	    	contentPane2.jlblLastVariance.setText("");
	    	contentPane2.jlblPercentImprovement.setText("");
	    	contentPane2.jlblPhase.setText("I");
	    	contentPane2.jlblTimeElapsed.setText("");
	    	contentPane2.jlblVariance.setText("");
	    	contentPane2.jProgressBar.setString("");
	    	contentPane2.jProgressBar.setIndeterminate(false);
	    	contentPane2.jbtnNextStep.setEnabled(false);
	    	contentPane2.m_GraphControl.RemoveAllSeries();
	    	contentPane2.m_GraphControlFlow.RemoveAllSeries();
	        contentPane2.jpanelStep6.setVisible(false);
	        contentPane2.jpanelStep5.setVisible(true);

			// Get dead time data
			double dVmMax = 0;
			
			for (int i = 0; i < Globals.dDeadTimeArray.length; i++)
			{
				if (Globals.dDeadTimeArray[i][1] > dVmMax)
				{
					dVmMax = Globals.dDeadTimeArray[i][1];
				}
			}	    
			
	    	// Set the table to contain the correct data
	    	contentPane2.tmOutputModel.getDataVector().clear();
	    	for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
	    	{
	    		Object[] newRow = {contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0), contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1), null, null};
		    	contentPane2.tmOutputModel.addRow(newRow);
	    	}
	    	
			m_vectCalSolutes.clear();
			// Grab the data out of tmOutputModel and add an index to each
			for (int i = 0; i < contentPane2.tmOutputModel.getRowCount(); i++)
			{
				// Find the index of the solute
				int iIndex = 0;
				for (int j = 0; j < Globals.CompoundNameArray.length; j++)
				{
					if (Globals.CompoundNameArray[j] == contentPane2.tmOutputModel.getValueAt(i, 0))
					{
						iIndex = j;
						break;
					}
				}
				
				Object[] newSolute = {iIndex, contentPane2.tmOutputModel.getValueAt(i, 1)};
				m_vectCalSolutes.add(newSolute);
			}

	    	m_dPlotXMax2 = (((Double)m_vectCalSolutes.get(m_vectCalSolutes.size() - 1)[1] - (dVmMax/m_dFlowRate)));
	    	
	    	// Here is where we set the value of m_dtstep
	    	m_dtstep = m_dPlotXMax2 * (0.01 / 15);
	    	
	    	int iIdealPlotIndex = contentPane2.m_GraphControl.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false);
	    	int iIdealPlotIndexFlow = contentPane2.m_GraphControlFlow.AddSeries("Ideal Flow Rate", new Color(0, 0, 0), 1, false);
	    	
	    	m_iInterpolatedGradientSeries = contentPane2.m_GraphControl.AddSeries("Interpolated Gradient", new Color(255,0,0), 1, false);
		    m_iGradientMarkerSeries = contentPane2.m_GraphControl.AddSeries("Gradient Markers", new Color(255,0,0), 1, true);
		    
	    	m_iInterpolatedFlowSeries = contentPane2.m_GraphControlFlow.AddSeries("Interpolated Flow", new Color(255,0,0), 1, false);
		    m_iFlowRateMarkerSeries = contentPane2.m_GraphControlFlow.AddSeries("Flow Rate Markers", new Color(255,0,0), 1, true);

		    // Add in data points for the ideal series
	    	contentPane2.m_GraphControl.AddDataPoint(iIdealPlotIndex, 0, m_dStartingComposition * 100);
	    	contentPane2.m_GraphControl.AddDataPoint(iIdealPlotIndex, (m_dGradientTime * 60), m_dEndingComposition * 100);
	    	contentPane2.m_GraphControl.AddDataPoint(iIdealPlotIndex, Math.max(m_dPlotXMax2, m_dGradientTime) * 60, m_dEndingComposition * 100);

	    	contentPane2.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, 0, m_dFlowRate / 1000);
	    	contentPane2.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, Math.max(m_dPlotXMax2, m_dGradientTime) * 60, m_dFlowRate / 1000);
	    	
			// Select number of data points for the gradient and flow profiles
			int iTotalDataPoints = m_vectCalSolutes.size();
			
			// 11/15ths of the data points should be on the gradient profile
			int iNumGradientDataPoints = (int)(((double)11/(double)15)*(double)iTotalDataPoints);
			int iNumFlowDataPoints = iTotalDataPoints - iNumGradientDataPoints;
			
			if (iNumFlowDataPoints < 3)
			{
				iNumFlowDataPoints = 3;
				iNumGradientDataPoints = iTotalDataPoints - iNumFlowDataPoints;
			}
			
			// Create initial gradient and flow rate arrays
			m_dGradientArray = new double [iNumGradientDataPoints][2];
			m_dFlowRateArray = new double [iNumFlowDataPoints][2];
			
			m_dGradientArray[0][0] = 0;
			m_dGradientArray[0][1] = m_dStartingComposition;
			
			for (int i = 1; i < iNumGradientDataPoints; i++)
			{
				m_dGradientArray[i][0] = ((Double)m_vectCalSolutes.get(m_vectCalSolutes.size() - 1)[1] - (dVmMax/m_dFlowRate)) * ((double)i / ((double)iNumGradientDataPoints - 1));
				m_dGradientArray[i][1] = Math.min(Math.max(m_dStartingComposition, ((m_dEndingComposition - m_dStartingComposition)/m_dGradientTime) * (((Double)m_vectCalSolutes.get(m_vectCalSolutes.size() - 1)[1] - (dVmMax/m_dFlowRate))) * ((double)i / ((double)iNumGradientDataPoints - 1)) + m_dStartingComposition), 1);
			}
			
			for (int i = 0; i < iNumFlowDataPoints; i++)
			{
				m_dFlowRateArray[i][0] = ((Double)m_vectCalSolutes.get(m_vectCalSolutes.size() - 1)[1] - (dVmMax/m_dFlowRate)) * ((double)i/((double)iNumFlowDataPoints - 1));
				m_dFlowRateArray[i][1] = m_dFlowRate;
			}
			
			m_InterpolatedGradient = new InterpolationFunction(m_dGradientArray);
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);

			setContentPane(contentPane2);
			this.UpdateGraphs();

	    }
	    else if (strActionCommand == "Previous Step")
	    {
			if (m_iStage == 2)
			{
				setContentPane(contentPane);
				if (task != null)
				{
					task.cancel(true);	
				}
				m_iStage = 1;
			}
			else if (m_iStage == 3)
			{
				if (taskPredict != null)
				{
					taskPredict.cancel(true);
				}
				
				contentPane2.jpanelStep6.setVisible(false);
				contentPane2.jpanelStep5.setVisible(true);
		    	contentPane2.jbtnNextStep.setVisible(true);
				m_iStage = 2;
			}
	    }
	    else if (strActionCommand == "Calculate")
	    {
	    	BackCalculate();
	    }
	    else if (strActionCommand == "Stop Calculations")
	    {
	    	task.cancel(true);
	    }
	    else if (strActionCommand == "Next Step2")
	    {
	    	// Fill in the table with the solutes that weren't selected
	    	contentPane2.tmPredictionModel.getDataVector().clear();
	    	for (int i = 0; i < contentPane.tmSelectCompounds.getRowCount(); i++)
	    	{
	    		if ((Boolean)contentPane.tmSelectCompounds.getValueAt(i, 1) == false)
	    		{
		    		Object[] newRow = {contentPane.tmSelectCompounds.getValueAt(i, 0), null};
	    			contentPane2.tmPredictionModel.addRow(newRow);
	    		}
	    	}
	    	
	    	contentPane2.jpanelStep5.setVisible(false);
	    	contentPane2.jpanelStep6.setVisible(true);
	    	contentPane2.jbtnNextStep.setVisible(false);
	    	contentPane2.jbtnPredict.setEnabled(true);
	    	contentPane2.jProgressBar2.setString("");
	    	contentPane2.jProgressBar2.setIndeterminate(false);
	    	
	    	m_iStage++;
	    }
	    else if (strActionCommand == "Predict")
	    {
	    	contentPane2.jbtnPredict.setEnabled(false);
			contentPane2.jProgressBar2.setIndeterminate(true);
			contentPane2.jProgressBar2.setStringPainted(true);
			contentPane2.jProgressBar2.setString("Please wait, calculating retention...");
			taskPredict = new TaskPredict();
			taskPredict.execute();
	    }
	    else if (strActionCommand == "Preloaded Values")
	    {
	    	Frame[] frames = Frame.getFrames();
	    	PreloadedValuesDialog dlgPreloadedValues = new PreloadedValuesDialog(frames[0]);
	    	
	    	// Show the dialog.
	    	dlgPreloadedValues.setVisible(true);
	    	
	    	if (dlgPreloadedValues.m_bOk == false)
	    		return;
	    	
	    	// Change settings
	    	contentPane.jtxtInitialSolventComposition.setText("10.0");
	    	contentPane.jtxtFinalSolventComposition.setText("100.0");
	    	
	    	if (dlgPreloadedValues.m_iCondition == 0)
	    	{
	    		contentPane.jtxtFlowRate.setText("0.2");
	    		contentPane.jtxtGradientTime.setText("5");
	    	}
	    	else if (dlgPreloadedValues.m_iCondition == 1)
	    	{
	    		contentPane.jtxtFlowRate.setText("0.1");
	    		contentPane.jtxtGradientTime.setText("20");
	    	}
	    	else if (dlgPreloadedValues.m_iCondition == 2)
	    	{
	    		contentPane.jtxtFlowRate.setText("0.2");
	    		contentPane.jtxtGradientTime.setText("20");
	    	}
	    	else if (dlgPreloadedValues.m_iCondition == 3)
	    	{
	    		contentPane.jtxtFlowRate.setText("0.4");
	    		contentPane.jtxtGradientTime.setText("20");
	    	}
	    	else if (dlgPreloadedValues.m_iCondition == 4)
	    	{
	    		contentPane.jtxtFlowRate.setText("0.2");
	    		contentPane.jtxtGradientTime.setText("80");
	    	}
	    	
    		// Put in default values
	    	for (int i = 0; i < contentPane.tmSelectCompounds.getRowCount(); i++)
	    	{
	    		contentPane.tmSelectCompounds.setValueAt(false, i, 1);
	    	}
	    	
			for (int i = 0; i < Globals.dPredefinedValues[dlgPreloadedValues.m_iInstrument][dlgPreloadedValues.m_iCondition].length; i++)
			{
				contentPane.tmSelectCompounds.setValueAt(true, (int)Globals.dPredefinedValues[dlgPreloadedValues.m_iInstrument][dlgPreloadedValues.m_iCondition][i][0], 1);
	            contentPane.tmMeasuredRetentionTimes.setValueAt(Globals.dPredefinedValues[dlgPreloadedValues.m_iInstrument][dlgPreloadedValues.m_iCondition][i][1], i, 1);
			}
			
	    	performValidations();
	    }
	}

	//@Override
	public void keyPressed(KeyEvent arg0) 
	{
		
	}

	//@Override
	public void keyReleased(KeyEvent e) 
	{

	}

	//@Override
	public void keyTyped(KeyEvent e) 
	{
		//JTextField source = (JTextField)e.getSource();
		
		if (!((Character.isDigit(e.getKeyChar()) ||
				(e.getKeyChar() == KeyEvent.VK_BACK_SPACE) ||
				(e.getKeyChar() == KeyEvent.VK_DELETE) ||
				(e.getKeyChar() == KeyEvent.VK_PERIOD))))
		{
	        e.consume();
		}
		
		if (e.getKeyChar() == KeyEvent.VK_ENTER)
		{
			performValidations();
		}
		
	}

	public void performValidations()
	{
		NumberFormat formatter = new DecimalFormat("#0.0000");
		
		validateStartingComposition();
		validateFinalComposition();
		validateGradientTime();
		validateFlowRate();

		double dMax = 0;
		for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
		{
			double dValue = (Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1);
			if (dValue > dMax)
				dMax = dValue;
		}
		
		m_dPlotXMax = Math.max(m_dGradientTime * 1.2, dMax * 1.02);
		
    	contentPane.m_GraphControl.RemoveAllSeries();
    	contentPane.m_GraphControlFlow.RemoveAllSeries();

    	int iIdealPlotIndex = contentPane.m_GraphControl.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false);
    	int iIdealPlotIndexFlow = contentPane.m_GraphControlFlow.AddSeries("Ideal Flow Rate", new Color(0, 0, 0), 1, false);

    	contentPane.m_GraphControl.AddDataPoint(iIdealPlotIndex, 0, m_dStartingComposition * 100);
    	contentPane.m_GraphControl.AddDataPoint(iIdealPlotIndex, (m_dGradientTime * 60), m_dEndingComposition * 100);
    	contentPane.m_GraphControl.AddDataPoint(iIdealPlotIndex, m_dPlotXMax * 60, m_dEndingComposition * 100);

    	contentPane.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, 0, m_dFlowRate / 1000);
    	contentPane.m_GraphControlFlow.AddDataPoint(iIdealPlotIndexFlow, m_dPlotXMax * 60, m_dFlowRate / 1000);

   		contentPane.m_GraphControl.AutoScaleX();
   		contentPane.m_GraphControl.AutoScaleY();
    	
    	contentPane.m_GraphControl.repaint();   
    	
   		contentPane.m_GraphControlFlow.AutoScaleX();
   		contentPane.m_GraphControlFlow.AutoScaleY();
    	
    	contentPane.m_GraphControlFlow.repaint();   	
	}

	//@Override
	public void focusGained(FocusEvent e) 
	{
		
	}

	//@Override
	public void focusLost(FocusEvent e) 
	{
		performValidations();
	}

	//@Override
	public void valueChanged(ListSelectionEvent arg0) 
	{
		performValidations();
		
	}
	
	//@Override
	public void autoScaleChanged(AutoScaleEvent event) 
	{
		//if(event.getSource()==contentPane.m_GraphControl)
		//{
/*			if (event.getAutoScaleXState() == true)
				contentPane.jbtnAutoscaleX.setSelected(true);
			else
				contentPane.jbtnAutoscaleX.setSelected(false);
			
			if (event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscaleY.setSelected(true);
			else
				contentPane.jbtnAutoscaleY.setSelected(false);
			
			if (event.getAutoScaleXState() == true && event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscale.setSelected(true);			
			else
				contentPane.jbtnAutoscale.setSelected(false);	
		}
		else if (event.getSource()==contentPane.m_GraphControlFlow)
		{
			if (event.getAutoScaleXState() == true)
				contentPane.jbtnAutoscaleXFlow.setSelected(true);
			else
				contentPane.jbtnAutoscaleXFlow.setSelected(false);
			
			if (event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscaleYFlow.setSelected(true);
			else
				contentPane.jbtnAutoscaleYFlow.setSelected(false);
			
			if (event.getAutoScaleXState() == true && event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscaleFlow.setSelected(true);			
			else
				contentPane.jbtnAutoscaleFlow.setSelected(false);				
		}*/
	}

	@Override
	public void tableChanged(TableModelEvent arg0) 
	{
		if(arg0.getSource() == contentPane.tmSelectCompounds)
		{
			int row = arg0.getFirstRow();
			int column = arg0.getColumn();
			
			if (column == 1)
			{
				Boolean bNewValue = (Boolean) contentPane.tmSelectCompounds.getValueAt(row, 1);
				
				if (bNewValue == true)
				{
					Object[] newRow = {Globals.CompoundNameArray[row], new Double(0.0)};
					contentPane.tmMeasuredRetentionTimes.addRow(newRow);
				}
				else
				{
					int numRows = contentPane.tmMeasuredRetentionTimes.getRowCount();
					for (int i = 0; i < numRows; i++)
					{
						if (contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0) == contentPane.tmSelectCompounds.getValueAt(row, 0))
						{
							contentPane.tmMeasuredRetentionTimes.removeRow(i);
							break;
						}
					}
				}
			}
		}
		else if (arg0.getSource() == contentPane.tmMeasuredRetentionTimes)
		{
			
		}
		
		performValidations();
		
		contentPane.m_GraphControl.removeAllLineMarkers();
		contentPane.m_GraphControlFlow.removeAllLineMarkers();
		
		for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
		{
			contentPane.m_GraphControl.addLineMarker((Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i,1), (String)contentPane.tmMeasuredRetentionTimes.getValueAt(i,0));
			contentPane.m_GraphControlFlow.addLineMarker((Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i,1), (String)contentPane.tmMeasuredRetentionTimes.getValueAt(i,0));
		}

		contentPane.m_GraphControl.repaint();
		contentPane.m_GraphControlFlow.repaint();
		
		// Make sure there are at least 6 unique measured retention times
		int iNumDifferent = 0;
		
		for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
		{
			double dValue = (Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1);
			boolean bSame = false;
			
			for (int j = 0; j < contentPane.tmMeasuredRetentionTimes.getRowCount(); j++)
			{
				if (j == i)
					continue;
				
				if ((Double)contentPane.tmMeasuredRetentionTimes.getValueAt(j, 1) == dValue)
				{
					bSame = true;
					break;
				}
			}
			
			if (bSame == false)
				iNumDifferent++;
		}
		
		if (iNumDifferent >= 6)
			contentPane.jbtnNextStep.setEnabled(true);
		else
			contentPane.jbtnNextStep.setEnabled(false);
	}
	
	public void UpdateGraphs()
	{
		synchronized(contentPane2.m_GraphControl.lockObject)
		{
		synchronized(contentPane2.m_GraphControlFlow.lockObject)
		{
		// Update the graphs with the new m_dGradientArray markers and the m_InterpolatedGradient (and the same with the flow graph)
		contentPane2.m_GraphControl.RemoveSeries(m_iInterpolatedGradientSeries);
		contentPane2.m_GraphControl.RemoveSeries(m_iGradientMarkerSeries);
		
		contentPane2.m_GraphControlFlow.RemoveSeries(m_iInterpolatedFlowSeries);
		contentPane2.m_GraphControlFlow.RemoveSeries(m_iFlowRateMarkerSeries);
		
	    m_iInterpolatedGradientSeries = contentPane2.m_GraphControl.AddSeries("Interpolated Gradient", new Color(255,0,0), 1, false);
	    m_iGradientMarkerSeries = contentPane2.m_GraphControl.AddSeries("Gradient Markers", new Color(255,0,0), 1, true);

	    m_iInterpolatedFlowSeries = contentPane2.m_GraphControlFlow.AddSeries("Interpolated Flow", new Color(255,0,0), 1, false);
	    m_iFlowRateMarkerSeries = contentPane2.m_GraphControlFlow.AddSeries("Flow Rate Markers", new Color(255,0,0), 1, true);

	    int iNumPoints = 1000;
	    for (int i = 0; i < iNumPoints; i++)
	    {
	    	double dXPos = ((double)i / (double)(iNumPoints - 1)) * (m_dPlotXMax2 * 60);
	    	contentPane2.m_GraphControl.AddDataPoint(m_iInterpolatedGradientSeries, dXPos, m_InterpolatedGradient.getAt(dXPos / 60) * 100);
	    	contentPane2.m_GraphControlFlow.AddDataPoint(m_iInterpolatedFlowSeries, dXPos, m_InterpolatedFlowRate.getAt(dXPos / 60) / 1000);
	    }
	    
	    for (int i = 0; i < m_dGradientArray.length; i++)
	    {
	    	contentPane2.m_GraphControl.AddDataPoint(m_iGradientMarkerSeries, m_dGradientArray[i][0] * 60, m_dGradientArray[i][1] * 100);
	    }
		
	    for (int i = 0; i < m_dFlowRateArray.length; i++)
	    {
	    	contentPane2.m_GraphControlFlow.AddDataPoint(m_iFlowRateMarkerSeries, m_dFlowRateArray[i][0] * 60, m_dFlowRateArray[i][1] / 1000);
	    }
	    
	    contentPane2.m_GraphControl.AutoScaleX();
	    contentPane2.m_GraphControl.AutoScaleY();
	    contentPane2.m_GraphControlFlow.AutoScaleX();
	    contentPane2.m_GraphControlFlow.AutoScaleY();
     
	    contentPane2.m_GraphControl.repaint();
	    contentPane2.m_GraphControlFlow.repaint();
		}
		}
	}
	
	public void BackCalculate()
	{
		contentPane2.jbtnCalculate.setEnabled(false);
		//contentPane2.jbtnCalculate.setText("Please wait...");
		contentPane2.jProgressBar.setIndeterminate(true);
		contentPane2.jProgressBar.setStringPainted(true);
		contentPane2.jProgressBar.setString("Please wait, optimization in progress...");
		task = new Task();
        task.execute();
	}
	
    class Task extends SwingWorker<Void, Void> 
    {
        /*
         * Main task. Executed in background thread.
         */
        @Override
        public Void doInBackground() 
        {
            Calculate(this);

            return null;
        }
        
        /*
         * Executed in event dispatching thread
         */
        @Override
        public void done() 
        {
    		contentPane2.jbtnNextStep.setEnabled(true);
    		contentPane2.jProgressBar.setIndeterminate(false);
    		contentPane2.jProgressBar.setStringPainted(true);
    		contentPane2.jProgressBar.setString("Optimization complete! Continue to next step.");
        }
    }

    class TaskPredict extends SwingWorker<Void, Void> 
    {
        /*
         * Main task. Executed in background thread.
         */
        @Override
        public Void doInBackground() 
        {
    		NumberFormat formatter = new DecimalFormat("#0.000");
    		int iIndex = 0;
    		
    		int iNumCompounds = contentPane.tmSelectCompounds.getRowCount();
    		for (int iCompound = 0; iCompound < iNumCompounds; iCompound++)
    		{
    			if ((Boolean)contentPane.tmSelectCompounds.getValueAt(iCompound, 1) == true)
    				continue;
    			
				if (taskPredict.isCancelled())
				{
					return null;
				}

				InterpolationFunction IsocraticData = new InterpolationFunction(Globals.IsocraticDataArray[iCompound]);
    			double dIntegral = 0;
    			double dtRFinal = 0;
    			double dD = 0;
    			double dTotalTime = 0;
    			double dTotalDeadTime = 0;
    			double dXPosition = 0;
    			double[] dLastXPosition = {0,0};
    			double[] dLastko = {0,0};
    			double dXMovement = 0;
    			Boolean bIsEluted = false;
    			double dPhiC = 0;
    			double dCurVal = 0;
    			
    			for (double t = 0; t <= (Double) m_vectCalSolutes.get(m_vectCalSolutes.size() - 1)[1] * 1.5; t += m_dtstep)
    			{
    				dPhiC = m_InterpolatedGradient.getAt(dTotalTime - dIntegral);
    				dCurVal = m_dtstep / (Math.pow(10, IsocraticData.getAt(dPhiC)));
    				double dt0 = m_Vm.getAt(dPhiC)/m_InterpolatedFlowRate.getAt(dTotalTime - dIntegral);
    				dXMovement = dCurVal / dt0;
    				
    				if (dXPosition >= 1)
    				{
    					dD = ((1 - dLastXPosition[0])/(dXPosition - dLastXPosition[0])) * (dTotalDeadTime - dLastXPosition[1]) + dLastXPosition[1]; 
    				}
    				else
    				{
    					dLastXPosition[0] = dXPosition;
    					dLastXPosition[1] = dTotalDeadTime;
    				}
    				
    				dTotalDeadTime += dXMovement * dt0;
    				
    				if (dXPosition >= 1)
    				{
    					dtRFinal = ((dD - dLastko[0])/(dIntegral - dLastko[0]))*(dTotalTime - dLastko[1]) + dLastko[1];
    				}
    				else
    				{
    					dLastko[0] = dIntegral;
    					dLastko[1] = dTotalTime;
    				}
    				
    				dTotalTime += m_dtstep + dCurVal;
    				dIntegral += dCurVal;
    				
    				if (dXPosition > 1 && bIsEluted == false)
    				{
    					bIsEluted = true;
    					break;
    				}
    				
    				dXPosition += dXMovement;
    			}
    			
    			if (bIsEluted)
    			{
    				contentPane2.tmPredictionModel.setValueAt(formatter.format(dtRFinal), iIndex, 1);
    			}
    			else
    			{
    				contentPane2.tmPredictionModel.setValueAt("Did not elute", iIndex, 1);
    			}
    			
    			iIndex++;
    		}
    				
            return null;
        }
        
        /*
         * Executed in event dispatching thread
         */
        @Override
        public void done() 
        {
    		contentPane2.jProgressBar2.setIndeterminate(false);
    		contentPane2.jProgressBar2.setStringPainted(true);
    		contentPane2.jProgressBar2.setString("Retention predictions complete.");
        }
    }
    
    public double CalcRetentionError(double dtstep)
    {
		NumberFormat formatter = new DecimalFormat("#0.0000");
    	double dRetentionError = 0;
		int iNumCompounds = m_vectCalSolutes.size();
		
		for (int iCompound = 0; iCompound < iNumCompounds; iCompound++)
		{
			double dIntegral = 0;
			double dtRFinal = 0;
			double dD = 0;
			double dTotalTime = 0;
			double dTotalDeadTime = 0;
			double dXPosition = 0;
			double[] dLastXPosition = {0,0};
			double[] dLastko = {0,0};
			double dXMovement = 0;
			Boolean bIsEluted = false;
			double dPhiC = 0;
			double dCurVal = 0;
			
			for (double t = 0; t <= (Double) m_vectCalSolutes.get(m_vectCalSolutes.size() - 1)[1] * 1.5; t += dtstep)
			{
				dPhiC = m_InterpolatedGradient.getAt(dTotalTime - dIntegral);
				dCurVal = dtstep / (Math.pow(10, m_IsocraticDataInterpolated[iCompound].getAt(dPhiC)));
				double dt0 = m_Vm.getAt(dPhiC)/m_InterpolatedFlowRate.getAt(dTotalTime - dIntegral);
				dXMovement = dCurVal / dt0;
				
				if (dXPosition >= 1)
				{
					dD = ((1 - dLastXPosition[0])/(dXPosition - dLastXPosition[0])) * (dTotalDeadTime - dLastXPosition[1]) + dLastXPosition[1]; 
				}
				else
				{
					dLastXPosition[0] = dXPosition;
					dLastXPosition[1] = dTotalDeadTime;
				}
				
				dTotalDeadTime += dXMovement * dt0;
				
				if (dXPosition >= 1)
				{
					dtRFinal = ((dD - dLastko[0])/(dIntegral - dLastko[0]))*(dTotalTime - dLastko[1]) + dLastko[1];
				}
				else
				{
					dLastko[0] = dIntegral;
					dLastko[1] = dTotalTime;
				}
				
				dTotalTime += dtstep + dCurVal;
				dIntegral += dCurVal;
				
				if (dXPosition > 1 && bIsEluted == false)
				{
					bIsEluted = true;
					break;
				}
				
				dXPosition += dXMovement;
			}
			
			if (bIsEluted)
			{
				dRetentionError += Math.pow(dtRFinal - (Double)m_vectCalSolutes.get(iCompound)[1], 2);
				contentPane2.tmOutputModel.setValueAt(formatter.format(dtRFinal), iCompound, 2);
				contentPane2.tmOutputModel.setValueAt(formatter.format(dtRFinal - (Double)m_vectCalSolutes.get(iCompound)[1]), iCompound, 3);
			}
			else
			{
				dRetentionError += Math.pow((Double)m_vectCalSolutes.get(iCompound)[1], 2);
				contentPane2.tmOutputModel.setValueAt("Did not elute", iCompound, 2);
				contentPane2.tmOutputModel.setValueAt("-", iCompound, 3);
			}
		}
				
    	return dRetentionError;
    }
    
    public void UpdateTime(long starttime)
    {
		NumberFormat timeformatter = new DecimalFormat("00");
		
		long currentTime = System.currentTimeMillis();
		long lNumSecondsPassed = (currentTime - starttime) / 1000;
		long lNumDaysPassed = lNumSecondsPassed / (24 * 60 * 60);
		lNumSecondsPassed -= lNumDaysPassed * (24 * 60 * 60);
		long lNumHoursPassed = lNumSecondsPassed / (60 * 60);
		lNumSecondsPassed -= lNumHoursPassed * (60 * 60);
		long lNumMinutesPassed = lNumSecondsPassed / (60);
		lNumSecondsPassed -= lNumMinutesPassed * (60);
		
		String strProgress2 = "";
		strProgress2 += timeformatter.format(lNumHoursPassed) + ":" + timeformatter.format(lNumMinutesPassed) + ":" + timeformatter.format(lNumSecondsPassed);
		contentPane2.jlblTimeElapsed.setText(strProgress2);
    }
    
	public void Calculate(Task task)
	{
		long starttime = System.currentTimeMillis();
		
		NumberFormat formatter1 = new DecimalFormat("#0.000000");
		NumberFormat formatter2 = new DecimalFormat("0.0000E0");
		NumberFormat percentFormatter = new DecimalFormat("0.00");
		
		m_Vm = new InterpolationFunction(Globals.dDeadTimeArray);
		
		// Step #1: Create interpolating functions for the isocratic data of each gradient calibration solute
		m_IsocraticDataInterpolated = new InterpolationFunction[contentPane2.tmOutputModel.getRowCount()];
		
		for (int i = 0; i < m_IsocraticDataInterpolated.length; i++)
		{
			Integer iIndex = (Integer) m_vectCalSolutes.get(i)[0];
			m_IsocraticDataInterpolated[i] = new InterpolationFunction(Globals.IsocraticDataArray[iIndex]);
		}
		
		// Step #4: Begin back-calculation
		int iPhase = 1;
		int iIteration = 0;
		double dRetentionError = 0;
		double dLastRetentionError = 0;
		double dLastFullIterationError = 0;
		double dPhiStep;
		double dRetentionAccuracy;
		double dMaxChangeAtOnce;
		double dPhiGuess;
		double dLastPhiGuess;
		
		while (true)
		{
			iIteration++;
			contentPane2.jlblIterationNumber.setText(((Integer)iIteration).toString());
			dLastFullIterationError = dRetentionError;
			
			// Run once for each data point. Start with the earliest data point.
			for (int iTimePoint = 0; iTimePoint < m_dGradientArray.length; iTimePoint++)
			{
				dPhiStep = -0.005;
				dRetentionAccuracy = 0.00001;
				dRetentionError = 1;
				dMaxChangeAtOnce = 0.02;
				
				dPhiGuess = m_dGradientArray[iTimePoint][1];
				dLastPhiGuess = m_dGradientArray[iTimePoint][1];
				
				while (Math.abs(dPhiStep) > dRetentionAccuracy)
				{
					m_dGradientArray[iTimePoint][1] = dPhiGuess;
					m_InterpolatedGradient = new InterpolationFunction(m_dGradientArray);
					
					dRetentionError = CalcRetentionError(m_dtstep);

					UpdateTime(starttime);
					
					String str;
					double dNum = dRetentionError / m_vectCalSolutes.size();
					if (dNum < 0.0001)
						str = formatter2.format(dNum);
					else
						str = formatter1.format(dNum);
					
					contentPane2.jlblVariance.setText(str);
					this.UpdateGraphs();
					
					if (task.isCancelled())
					{
						return;
					}
					// Decide what to do next
					if (dLastRetentionError - dRetentionError > 0)
					{
						// dPhiGuess was in the right direction
						// Continue with same step
						if (dPhiGuess == 1 || dPhiGuess == 0 || dPhiGuess > (dLastPhiGuess + dMaxChangeAtOnce) || dPhiGuess < (dLastPhiGuess - dMaxChangeAtOnce))
						{
							dLastRetentionError = dRetentionError;
							break;
						}
					}
					else
					{
						// dPhiGuess was in wrong direction
						
						// If the step was in the wrong direction and is the last step we're going to make
						// then put it back to what it was before
						
						if (Math.abs(dPhiStep/2) <= dRetentionAccuracy)
						{
							dPhiGuess -= dPhiStep;
							dLastRetentionError = dRetentionError;
							break;
						}
						
						// Switch directions, divide the step by two
						dPhiStep = -dPhiStep/2;
					}
					
					// Add the step to the guess
					dPhiGuess += dPhiStep;
					
					if (dPhiGuess < 0)
					{
						dPhiGuess = 0;
					}
					
					if (dPhiGuess > 1)
					{
						dPhiGuess = 1;
					}
					
					dLastRetentionError = dRetentionError;
				}
			}
			
			if (iPhase == 2)
			{
				// Now we optimize the flow rate profile
				for (int iTimePoint = 0; iTimePoint < m_dFlowRateArray.length; iTimePoint++)
				{
					double dFStep = -(m_dFlowRate/100);
					dRetentionAccuracy = m_dFlowRate / 100000;
					dRetentionError = 1;
					dMaxChangeAtOnce = m_dFlowRate / 20;
					
					double dFGuess = m_dFlowRateArray[iTimePoint][1];
					double dLastFGuess = m_dFlowRateArray[iTimePoint][1];
					
					while (Math.abs(dFStep) > dRetentionAccuracy)
					{
						m_dFlowRateArray[iTimePoint][1] = dFGuess;
						m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
						
						dRetentionError = CalcRetentionError(m_dtstep);
						
						UpdateTime(starttime);
						
						String str;
						double dNum = dRetentionError / m_vectCalSolutes.size();
						if (dNum < 0.0001)
							str = formatter2.format(dNum);
						else
							str = formatter1.format(dNum);
						
						contentPane2.jlblVariance.setText(str);
						this.UpdateGraphs();

						// Decide what to do next
						if (dLastRetentionError - dRetentionError > 0)
						{
							// dFGuess was in the right direction
							// Continue with the same step
							if (dFGuess == 0 || dFGuess > (dLastFGuess + dMaxChangeAtOnce) || dFGuess < (dLastFGuess - dMaxChangeAtOnce))
							{
								dLastRetentionError = dRetentionError;
								break;
							}
						}
						else
						{
							// dFGuess was in the wrong direction
							
							// If the step was in the wrong direction and is the last step we're going to make,
							// then put it back to what it was before.
							if (Math.abs(dFStep / 2) <= dRetentionAccuracy)
							{
								dFGuess -= dFStep;
								dLastRetentionError = dRetentionError;
								break;
							}
							
							// Switch directions and divide the step by two
							dFStep = -dFStep / 2;
						}
							
						dFGuess += dFStep;
							
						if (dFGuess < 0)
						{
							dFGuess = 0;
						}
							
						dLastRetentionError = dRetentionError;
					}
				}
			}
			
			// Check to see if we should move on to phase II
			if (dLastFullIterationError != 0)
			{
				double dNum = (1 - (dRetentionError / dLastFullIterationError)) * 100;
				
				if (dNum < 10 && dNum >= 0)
				{
					iPhase = 2;
					contentPane2.jlblPhase.setText("II");				
				}
			}
			
			String str;
			double dNum = dRetentionError / m_vectCalSolutes.size();
			
			if (dNum == 0)
				str = "";
			else if (dNum < 0.0001)
				str = formatter2.format(dNum);
			else
				str = formatter1.format(dNum);
			
			contentPane2.jlblLastVariance.setText(str);

			if (dLastFullIterationError != 0)
			{
				dNum = (1 - (dRetentionError / dLastFullIterationError)) * 100;
				contentPane2.jlblPercentImprovement.setText(percentFormatter.format(dNum) + "%");

				if (dNum < 1 && dNum >= 0)
				{
					// Optimization is complete.
					break;
				}
			}	
		}
	}
}
